<?php
/**
 * Plugin Name: SEORise Connector
 * Plugin URI: https://app.seorise.ai/
 * Description: WordPress integration with SEORise platform for publishing AI-generated content
 * Version: 2.0.0
 * Author: SEORise
 * Author URI: https://app.seorise.ai/
 * Text Domain: seorise-connector
 * Domain Path: /languages
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

// Protection against direct access
if (!defined('ABSPATH')) {
    exit;
}

// Constants definitions
define('SEORISE_CONNECTOR_VERSION', '1.1.0');
define('SEORISE_CONNECTOR_PATH', plugin_dir_path(__FILE__));
define('SEORISE_CONNECTOR_URL', plugin_dir_url(__FILE__));
define('SEORISE_CONNECTOR_BASENAME', plugin_basename(__FILE__));
define('SEORISE_API_URL', 'https://app.seorise.ai/api/v1');

// Automatic class loading
function seorise_connector_autoloader($class_name) {
    // Check if class belongs to our plugin
    if (strpos($class_name, 'SEORise_') === 0) {
        // Convert class name to file path
        $class_file = 'class-' . str_replace('_', '-', strtolower($class_name)) . '.php';
        $file_path = SEORISE_CONNECTOR_PATH . 'includes/' . $class_file;
        
        // If file exists, include it
        if (file_exists($file_path)) {
            require_once $file_path;
        }
    }
}
spl_autoload_register('seorise_connector_autoloader');

// Include files
require_once SEORISE_CONNECTOR_PATH . 'includes/class-seorise-connector.php';
require_once SEORISE_CONNECTOR_PATH . 'includes/class-seorise-security.php';
require_once SEORISE_CONNECTOR_PATH . 'includes/class-seorise-api.php';
require_once SEORISE_CONNECTOR_PATH . 'includes/class-seorise-content-handler.php';
require_once SEORISE_CONNECTOR_PATH . 'includes/class-seorise-rest-api.php';

// Plugin activation
register_activation_hook(__FILE__, array('SEORise_Connector', 'activate'));

// Plugin deactivation
register_deactivation_hook(__FILE__, array('SEORise_Connector', 'deactivate'));

// Plugin initialization
function seorise_connector_init() {
    $seorise_connector = new SEORise_Connector();
    $seorise_connector->init();
}
add_action('plugins_loaded', 'seorise_connector_init');
