<?php
// Dashboard (v2-only): Pairing, Verify, Disconnect
?>
<div class="wrap seorise-admin">

    <?php 
    $connection_id = get_option('seorise_v2_connection_id', '');
    $key_id = get_option('seorise_v2_key_id', '');
    $last_verified = get_option('seorise_v2_last_verified_at', '');
    $is_connected = !empty($connection_id) && !empty($key_id);
    ?>

    <!-- Notifications -->
    <div class="seorise-notice seorise-notice-success" id="seorise-notification" style="display:none">
        <span class="dashicons dashicons-yes-alt"></span>
        <p></p>
    </div>

    <!-- Main Content Grid -->
    <div class="seorise-admin-content">
        <!-- Connection Card -->
        <div class="seorise-card">
            <h2>
                <span class="dashicons dashicons-admin-site-alt3"></span>
                <?php echo esc_html__('SEORise Connection', 'seorise-connector'); ?>
            </h2>

            <div class="seorise-status-box large <?php echo $is_connected ? 'connected' : 'disconnected'; ?>">
                <span class="dashicons dashicons-<?php echo $is_connected ? 'yes-alt' : 'warning'; ?>"></span>
                <p class="status-text"><?php echo $is_connected ? esc_html__('Connected', 'seorise-connector') : esc_html__('Not Connected', 'seorise-connector'); ?></p>
            </div>

            <?php if ($is_connected) : ?>
                <!-- Connected State -->
                <table class="seorise-info-table">
                    <tr>
                        <th><?php echo esc_html__('Status', 'seorise-connector'); ?></th>
                        <td>
                            <span class="seorise-status-badge connected">
                                <span class="dashicons dashicons-yes-alt"></span>
                                <?php echo esc_html__('Active', 'seorise-connector'); ?>
                            </span>
                        </td>
                    </tr>
                    
                    <tr>
                        <th><?php echo esc_html__('Key ID', 'seorise-connector'); ?></th>
                        <td><code><?php echo esc_html($key_id ?: __('N/A', 'seorise-connector')); ?></code></td>
                    </tr>
                    <tr>
                        <th><?php echo esc_html__('Site URL', 'seorise-connector'); ?></th>
                        <td><?php echo esc_url(get_site_url()); ?></td>
                    </tr>
                    <tr>
                        <th><?php echo esc_html__('Last Verified', 'seorise-connector'); ?></th>
                        <td><?php echo $last_verified ? esc_html($last_verified) : __('Never', 'seorise-connector'); ?></td>
                    </tr>
                </table>

                <div class="seorise-action-buttons">
                    <button id="seorise-v2-verify" class="seorise-button seorise-button-secondary">
                        <span class="dashicons dashicons-yes"></span>
                        <?php echo esc_html__('Verify Connection', 'seorise-connector'); ?>
                    </button>
                    <button id="seorise-v2-disconnect" class="seorise-button seorise-button-danger">
                        <span class="dashicons dashicons-no"></span>
                        <?php echo esc_html__('Disconnect from SEORise', 'seorise-connector'); ?>
                    </button>
                </div>
            <?php else : ?>
                <!-- Disconnected State -->
                <p><?php echo esc_html__('Connect your WordPress site to SEORise with one click. You will be redirected to log in at SEORise and returned here automatically.', 'seorise-connector'); ?></p>

                <div class="seorise-action-buttons" style="margin-top: 12px; gap: 10px; display: flex; flex-wrap: wrap;">
                    <button id="seorise-v2-connect-oauth" class="seorise-button seorise-button-primary" type="button">
                        <span class="dashicons dashicons-admin-links"></span>
                        <?php echo esc_html__('Connect', 'seorise-connector'); ?>
                    </button>
                </div>
            <?php endif; ?>
        </div>

        <!-- SEORise App Access (moved below main section) -->
        <div class="seorise-card">
            <h2>
                <span class="dashicons dashicons-external"></span>
                <?php echo esc_html__('SEORise Dashboard', 'seorise-connector'); ?>
            </h2>
            <p><?php echo esc_html__('Open the SEORise web app to manage content, settings and integrations.', 'seorise-connector'); ?></p>
            <div class="seorise-action-buttons">
                <a href="https://app.seorise.ai/" target="_blank" class="seorise-button seorise-button-primary" style="color:white">
                    <span class="dashicons dashicons-external"></span>
                    <?php echo esc_html__('Open SEORise Dashboard', 'seorise-connector'); ?>
                </a>
            </div>
        </div>

        <!-- Info/Features Card (removed) -->
        <div class="seorise-card" style="display:none">
            <h2>
                <span class="dashicons dashicons-info"></span>
                <?php echo esc_html__('How it Works', 'seorise-connector'); ?>
            </h2>

            <div class="seorise-features">
                <div class="seorise-feature">
                    <div class="seorise-feature-icon">
                        <span class="dashicons dashicons-edit"></span>
                    </div>
                    <h3><?php echo esc_html__('Create', 'seorise-connector'); ?></h3>
                    <p><?php echo esc_html__('Generate content with AI in SEORise platform', 'seorise-connector'); ?></p>
                </div>

                <div class="seorise-feature">
                    <div class="seorise-feature-icon">
                        <span class="dashicons dashicons-cloud-upload"></span>
                    </div>
                    <h3><?php echo esc_html__('Publish', 'seorise-connector'); ?></h3>
                    <p><?php echo esc_html__('Automatically publish to your WordPress site', 'seorise-connector'); ?></p>
                </div>

                <div class="seorise-feature">
                    <div class="seorise-feature-icon">
                        <span class="dashicons dashicons-chart-line"></span>
                    </div>
                    <h3><?php echo esc_html__('Grow', 'seorise-connector'); ?></h3>
                    <p><?php echo esc_html__('Scale your content production effortlessly', 'seorise-connector'); ?></p>
                </div>
            </div>

            <?php if ($is_connected) : ?>
                <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid var(--seorise-gray-200);">
                    <h3 style="margin-bottom: 10px;"><?php echo esc_html__('Quick Actions', 'seorise-connector'); ?></h3>
                    <a href="https://app.seorise.ai/dashboard" target="_blank" class="seorise-button seorise-button-secondary">
                        <span class="dashicons dashicons-external"></span>
                        <?php echo esc_html__('Open SEORise Dashboard', 'seorise-connector'); ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php if ($is_connected) : ?>
    <!-- New section: Sync authors & categories with selection -->
    <div class="seorise-card">
        <h2>
            <span class="dashicons dashicons-update"></span>
            <?php echo esc_html__('Sync Authors & Categories', 'seorise-connector'); ?>
        </h2>
        <p style="margin-top:-6px;color:#666;">
            <?php echo esc_html__('Choose which authors and categories to sync to SEORise. Leave empty to sync none.', 'seorise-connector'); ?>
        </p>
        <div style="display:flex; gap:24px; flex-wrap:wrap;">
            <div style="flex:1; min-width:260px;">
                <div id="seorise-authors-list" style="max-height:220px; overflow:auto; border:1px solid #e2e8f0; padding:8px; border-radius:6px;">
                    <?php
                    // Build authors list (users with edit/publish rights)
                    $users = get_users(array('fields' => array('ID','display_name')));
                    foreach ($users as $u) {
                        $uid = intval(is_object($u) ? $u->ID : $u['ID']);
                        if (user_can($uid, 'edit_posts') || user_can($uid, 'publish_posts')) {
                            $name = esc_html(is_object($u) ? $u->display_name : $u['display_name']);
                            echo '<label style="display:flex; align-items:center; gap:8px; margin:4px 0;">'
                                 . '<input type="checkbox" class="seorise-author-item" value="'.esc_attr($uid).'" />'
                                 . '<span>'.$name.'</span>'
                                 . '</label>';
                        }
                    }
                    ?>
                </div>
                <div class="seorise-action-buttons" style="margin-top:10px;">
                    <button id="seorise-v2-sync-authors-selected" class="seorise-button seorise-button-secondary">
                        <span class="dashicons dashicons-admin-users"></span>
                        <?php echo esc_html__('Sync Selected Authors', 'seorise-connector'); ?>
                    </button>
                </div>
            </div>
            <div style="flex:1; min-width:260px;">
                <div id="seorise-categories-list" style="max-height:220px; overflow:auto; border:1px solid #e2e8f0; padding:8px; border-radius:6px;">
                    <?php
                    $cats = get_categories(array('hide_empty' => false));
                    if (is_array($cats)) {
                        foreach ($cats as $c) {
                            echo '<label style="display:flex; align-items:center; gap:8px; margin:4px 0;">'
                                 . '<input type="checkbox" class="seorise-category-item" value="'.esc_attr($c->term_id).'" />'
                                 . '<span>'.esc_html($c->name).' ('.esc_html($c->slug).')</span>'
                                 . '</label>';
                        }
                    }
                    ?>
                </div>
                <div class="seorise-action-buttons" style="margin-top:10px;">
                    <button id="seorise-v2-sync-categories-selected" class="seorise-button seorise-button-secondary">
                        <span class="dashicons dashicons-category"></span>
                        <?php echo esc_html__('Sync Selected Categories', 'seorise-connector'); ?>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    
</div>

<script>
jQuery(document).ready(function($) {
    // If callback indicated error, show Not Connected explicitly and surface reason
    if (typeof seorise_data !== 'undefined' && seorise_data.error) {
        var $status = $('.seorise-status-box');
        $status.removeClass('connected').addClass('disconnected');
        $status.find('.status-text').text('<?php echo esc_js(__('Not Connected', 'seorise-connector')); ?>');
        if (typeof window.showSEORiseNotification === 'function') {
            var msg = '<?php echo esc_js(__('Connection failed. Please try again.', 'seorise-connector')); ?>';
            if (seorise_data.error === 'rate_limited') {
                msg = '<?php echo esc_js(__('Too many requests. Please try again in a minute.', 'seorise-connector')); ?>';
            }
            window.showSEORiseNotification(msg, 'error');
        }
    }
    // Pairing code fallback removed
    // v2 Connect
    $('#seorise-v2-connect-oauth').on('click', function(e){
        e.preventDefault();
        if (typeof seorise_data !== 'undefined' && seorise_data.authorize_url){
            window.location = seorise_data.authorize_url;
        } else {
            if (typeof window.showSEORiseNotification === 'function') {
                window.showSEORiseNotification('<?php echo esc_js(__('Authorization URL not available. Reload the page and try again.', 'seorise-connector')); ?>', 'error');
            }
        }
    });

    // Pairing code fallback removed

    // v2 Verify
    $('#seorise-v2-verify').on('click', function(e){
        e.preventDefault();
        var $btn = $(this); var original = $btn.html();
        $btn.prop('disabled', true).html('<span class="seorise-spinner"></span> <?php echo esc_js(__('Verifying...', 'seorise-connector')); ?>');
        $.post(seorise_data.ajax_url, { action: 'seorise_v2_verify', nonce: seorise_data.nonce })
         .done(function(resp){
            if (resp.success) {
                if (typeof window.showSEORiseNotification === 'function') {
                    window.showSEORiseNotification('<?php echo esc_js(__('Connection verified.', 'seorise-connector')); ?>', 'success');
                }
                location.reload();
            } else {
                var msg = (resp.data && resp.data.message) ? resp.data.message : 'Verify failed';
                var code = (resp.data && resp.data.error_code) ? String(resp.data.error_code) : '';
                // If key is unknown on server, reflect Not Connected in UI
                if (code === '401' || /(unknown_key_id|not\s*configured|key\s*not\s*found)/i.test(msg)) {
                    var $status = $('.seorise-status-box');
                    $status.removeClass('connected').addClass('disconnected');
                    $status.find('.status-text').text('<?php echo esc_js(__('Not Connected', 'seorise-connector')); ?>');
                    if (typeof window.showSEORiseNotification === 'function') {
                        window.showSEORiseNotification('<?php echo esc_js(__('Server does not recognize this key. Please reconnect.', 'seorise-connector')); ?>', 'error');
                    }
                } else {
                    if (typeof window.showSEORiseNotification === 'function') {
                        window.showSEORiseNotification(msg, 'error');
                    }
                }
            }
         })
         .fail(function(){ 
            if (typeof window.showSEORiseNotification === 'function') {
                window.showSEORiseNotification('<?php echo esc_js(__('Network error', 'seorise-connector')); ?>', 'error');
            }
         })
         .always(function(){ $btn.prop('disabled', false).html(original); });
    });

    // v2 Disconnect
    $('#seorise-v2-disconnect').on('click', function(e){
        e.preventDefault();
        var $btn = $(this); var original = $btn.html();
        $btn.prop('disabled', true).html('<span class="seorise-spinner"></span> <?php echo esc_js(__('Disconnecting...', 'seorise-connector')); ?>');
        $.post(seorise_data.ajax_url, { action: 'seorise_v2_disconnect', nonce: seorise_data.nonce })
         .done(function(resp){ 
            if (resp.success) { 
                if (typeof window.showSEORiseNotification === 'function') {
                    window.showSEORiseNotification('<?php echo esc_js(__('Disconnected successfully.', 'seorise-connector')); ?>', 'success');
                }
                location.reload(); 
            } else { 
                var msg = (resp.data && resp.data.message) ? resp.data.message : 'Disconnect failed';
                if (typeof window.showSEORiseNotification === 'function') {
                    window.showSEORiseNotification(msg, 'error');
                }
            } 
         })
         .fail(function(){ 
            if (typeof window.showSEORiseNotification === 'function') {
                window.showSEORiseNotification('<?php echo esc_js(__('Network error', 'seorise-connector')); ?>', 'error');
            }
         })
         .always(function(){ $btn.prop('disabled', false).html(original); });
    });

    // v2 Sync Authors
    $('#seorise-v2-sync-authors, #seorise-v2-sync-authors-selected').on('click', function(e){
        e.preventDefault();
        var $btn = $(this); var original = $btn.html();
        $btn.prop('disabled', true).html('<span class="seorise-spinner"></span> <?php echo esc_js(__('Syncing...', 'seorise-connector')); ?>');
        var ids = [];
        $('#seorise-authors-list input.seorise-author-item:checked').each(function(){ ids.push(String($(this).val())); });
        $.post(seorise_data.ajax_url, { action: 'seorise_v2_sync_authors', nonce: seorise_data.nonce, author_ids: ids })
         .done(function(resp){
            if (resp.success) {
                if (typeof window.showSEORiseNotification === 'function') {
                    var c = (resp.data && resp.data.count) ? resp.data.count : 0;
                    window.showSEORiseNotification('<?php echo esc_js(__('Authors synced: ', 'seorise-connector')); ?>' + c, 'success');
                }
            } else {
                var msg = (resp.data && resp.data.message) ? resp.data.message : 'Sync failed';
                if (typeof window.showSEORiseNotification === 'function') {
                    window.showSEORiseNotification(msg, 'error');
                }
            }
         })
         .fail(function(){
            if (typeof window.showSEORiseNotification === 'function') {
                window.showSEORiseNotification('<?php echo esc_js(__('Network error', 'seorise-connector')); ?>', 'error');
            }
         })
         .always(function(){ $btn.prop('disabled', false).html(original); });
    });

    // v2 Sync Categories
    $('#seorise-v2-sync-categories, #seorise-v2-sync-categories-selected').on('click', function(e){
        e.preventDefault();
        var $btn = $(this); var original = $btn.html();
        $btn.prop('disabled', true).html('<span class="seorise-spinner"></span> <?php echo esc_js(__('Syncing...', 'seorise-connector')); ?>');
        var ids = [];
        $('#seorise-categories-list input.seorise-category-item:checked').each(function(){ ids.push(String($(this).val())); });
        $.post(seorise_data.ajax_url, { action: 'seorise_v2_sync_categories', nonce: seorise_data.nonce, category_ids: ids })
         .done(function(resp){
            if (resp.success) {
                if (typeof window.showSEORiseNotification === 'function') {
                    var c = (resp.data && resp.data.count) ? resp.data.count : 0;
                    window.showSEORiseNotification('<?php echo esc_js(__('Categories synced: ', 'seorise-connector')); ?>' + c, 'success');
                }
            } else {
                var msg = (resp.data && resp.data.message) ? resp.data.message : 'Sync failed';
                if (typeof window.showSEORiseNotification === 'function') {
                    window.showSEORiseNotification(msg, 'error');
                }
            }
         })
         .fail(function(){
            if (typeof window.showSEORiseNotification === 'function') {
                window.showSEORiseNotification('<?php echo esc_js(__('Network error', 'seorise-connector')); ?>', 'error');
            }
         })
         .always(function(){ $btn.prop('disabled', false).html(original); });
    });
});
</script>

