<?php
/**
 * Uninstall script for SEORise Connector (v2-only)
 */

if (!defined('WP_UNINSTALL_PLUGIN')) { exit; }

// Notify API about disconnect (v2 HMAC), if credentials present
$v2_connection_id = get_option('seorise_v2_connection_id');
$v2_key_id        = get_option('seorise_v2_key_id');
$v2_key_secret    = get_option('seorise_v2_key_secret');

if (!empty($v2_connection_id) && !empty($v2_key_id) && !empty($v2_key_secret)) {
    $endpoint = '/api/v1/wordpress/disconnect';
    $url = 'https://app.seorise.ai' . $endpoint;
    $body = wp_json_encode(array('connection_id' => $v2_connection_id));
    $content_sha = hash('sha256', $body);
    $timestamp = (string) time();
    $nonce = function_exists('wp_generate_uuid4') ? wp_generate_uuid4() : uniqid('seorise_', true);
    $base = 'POST' . '|' . $endpoint . '|' . $timestamp . '|' . $nonce . '|' . $content_sha;
    $signature = hash_hmac('sha256', $base, $v2_key_secret);
    $headers = array(
        'Content-Type'   => 'application/json',
        'Authorization'  => 'SEORISE ' . $v2_key_id . ':' . $signature . ':' . $timestamp . ':' . $nonce,
        'Content-SHA256' => $content_sha,
    );
    $response = wp_remote_post($url, array(
        'headers'   => $headers,
        'body'      => $body,
        'timeout'   => 10,
        'sslverify' => true,
        'redirection' => 0,
    ));
    if (is_wp_error($response)) {
        error_log('SEORise uninstall (v2): Failed to notify API - ' . $response->get_error_message());
    } else {
        $status_code = wp_remote_retrieve_response_code($response);
        error_log('SEORise uninstall (v2): API notification status ' . $status_code);
    }
}

// Remove v2 options
delete_option('seorise_v2_connection_id');
delete_option('seorise_v2_key_id');
delete_option('seorise_v2_key_secret');
delete_option('seorise_v2_last_verified_at');

// Drop custom table if created earlier (optional cleanup)
global $wpdb;
$table_name = $wpdb->prefix . 'seorise_options';
$wpdb->query("DROP TABLE IF EXISTS $table_name");

// Clear any scheduled hooks (legacy)
wp_clear_scheduled_hook('seorise_daily_connection_check');
